/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Absent;
import com.google.common.base.Preconditions;
import com.google.common.base.Present;
import java.io.Serializable;

public abstract class Optional<T>
implements Serializable {
    public static <T> Optional<T> absent() {
        return Absent.withType();
    }

    public static <T> Optional<T> of(T reference) {
        return new Present<T>(Preconditions.checkNotNull(reference));
    }

    public static <T> Optional<T> fromNullable(T nullableReference) {
        return nullableReference == null ? Optional.absent() : new Present<T>(nullableReference);
    }

    Optional() {
    }

    public abstract boolean isPresent();

    public abstract T get();

    public abstract T or(T var1);
}

